//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12P128.h>     /* derivative information */
#include "target.h" 
#include "S12P_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
unsigned char LED_Flag;

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   unsigned int x;						 /* loop counter */
   char y,z;									 /* loop counter */

      /* initialise the system clock - 32MHz Bus CLK, 4MHz Crystal */
	 CPMUCLKS_PLLSEL = 1; /* select the PLL as the clock source */
	 CPMUOSC = 0xC8;
   while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */
   CPMUREFDIV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));       /* Reference Clock / 1 = 4MHz */
   CPMUSYNR = ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));         /* configure the PLL  x 16 = 64MHz VCO */
   CPMUPOSTDIV = (PLL_POSTDIVIDER-1);      /* Post divider / 1 = 32MHz Bus CLK */
   while(!CPMUFLG_LOCK)	/* wait for PLL to lock */
   {
   }
	    			  		
       /* Enable ECLK */
   ECLKCTL = 0x40;
   
       /* Enable LEDs */
   PORTA = 0x00;  /* Initialise PORT A all low; turn off LEDs */
   DDRA = 0x0F;   /* PORTA 3:0 outputs */

       /* Enable Port B */
   PUCR 	= 0xFE; /* Enable pull-ups on Port B */
   DDRB = 0x00;   /* Port B all inputs */
   
       /* Enable Interrupt on Port P, P0 */
   PERP_PERP0=0;
   PPSP_PPSP0=0;
   PIEP_PIEP0=1;
                
   EnableInterrupts;
   
   /* Wait for pull ups to come into effect */
  	for (x=0; x<1000; x++)
  	{	
  		for (y=0; y<100; y++)
  		{} 
	  }

    /* Select Low Power Mode via PB0 and PB1 switches */
    /*                                                */
    /*                PB1  PB0                        */
    /* Run Mode       off  off  (Default)             */
    /* Wait Mode      off   ON                        */
    /* Pseudo Stop     ON  off                        */
    /* Stop Mode       ON   ON                        */
    
      switch (PORTB)
      {
      
      case 0xFC: /* Stop Mode */

         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PORTA ^=0xFF;
               /* Delay to see LEDs toggle */
               for (x=0; x<5000; x++)
            	 {	
             		 for (y=0; y<100; y++)
            		 {} 
          	   }
            }
           
           asm ANDCC #0x7F; /* Clear S-bit in the CCR to enable STOP instruction */
      	   asm STOP;        /* Enter Stop mode */ 
         }
        		       
      break;
      
      case 0xFD: /* Pseudo Stop Mode */
                
         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PORTA ^=0xFF;
               /* Delay to see LEDs toggle */
               for (x=0; x<5000; x++)
            	 {	
             		 for (y=0; y<100; y++)
            		 {} 
          	   }
            }

           CPMUCLKS_PSTP = 1; /* Set PSTP bit to enable Pseudo Stop Mode */
           
           asm ANDCC #0x7F; /* Clear S-bit in the CCR to enable STOP instruction */
      	   asm STOP;        /* Enter Pseudo Stop mode */ 
         }

      break;
      
      case 0xFE: /* Wait Mode */

         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PORTA ^=0xFF;
               /* Delay to see LEDs toggle */
               for (x=0; x<5000; x++)
            	 {	
             		 for (y=0; y<100; y++)
            		 {} 
          	   }
            }
      	   asm WAI;  /* Enter Wait mode */ 
         }

      
      break;
      
      default:   /* Run Mode */

        {          
           while(1) /* Loop forever */
           {
             PORTA ^=0xFF;
             /* Delay to see LEDs toggle */
             for (x=0; x<5000; x++)
          	 {	
           		 for (y=0; y<100; y++)
          		 {} 
        	   }
           }
        }
}


   while(1)  /* Code should never reach here */
   {
     PORTA ^=0xFF;
   }
}


/******************************************************************************
Function Name	:	PORTP_ISR
Engineer		:	G.Borland
Date			:	15/06/09
Parameters		:	NONE
Returns			:	NONE
Notes			:	Interrupt service routine for PORTP module.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
interrupt void PORTP_ISR(void)
{
  /* Clear interrupt flag */
  	PIFP 	= 0x01;
} 

#pragma CODE_SEG DEFAULT
